//------------------------------------------------------------
// VelociBus_4X4BP Event Callback Example
// Turns on all LEDs in row & column of button pressed
//------------------------------------------------------------

#include "VelociBus_4X4BP.h"
VelociBus_4X4BP vbus; // create VelociBus interface, one required for each serial port used
#define VBUS_SERIAL Serial2

void setup() 
{
  Serial.begin(115200); // Serial monitor
  // button module on VeliciBus
  VBUS_SERIAL.begin(38400);    // VelociBus is always 38400
  // establish communication
  for (;;)
  { Serial.println("PROBING VelociBus...");
    if (vbus.begin( &VBUS_SERIAL )) break; // performs loopback diagnostic, tries 3 times, sets board_count
    delay(1000);
  }
  Serial.print("Found "); Serial.print(vbus.board_count); Serial.println(" Button Pad Modules");
  // establish button handler callback
  vbus.setHandler( myButtonHandler ); 
  // all we want is press & release events
  vbus.setButtonHoldEnable( false ); // don't report long press events
}

void loop() 
{
  vbus.loop(); // required, triggers button events
}

// button event callback
void myButtonHandler( uint8_t board_address, uint8_t button_index, VelociBus_4X4BP::button_event_code event )
{
Serial.println("CALLBACK");  
  if (event == VelociBus_4X4BP::BTN_PRESS)
  { // turn on all LEDs in button row
    vbus.setLEDrow( board_address, button_index / 4, VelociBus_4X4BP::FCN_COLOR, VelociBus_4X4BP::red );
    // turn on all LEDs in button column
    vbus.setLEDcol( board_address, button_index % 4, VelociBus_4X4BP::FCN_COLOR, VelociBus_4X4BP::red );
  }
  else // blank all LEDs on button release
    vbus.setLEDall( VelociBus_4X4BP::BOARD_BROADCAST_ADDR, VelociBus_4X4BP::FCN_COLOR, VelociBus_4X4BP::black );
}
